#include "../cpcglob.h"
#include "hfe.h"
#include "iextdsk.h"

int		Hfe_Validate(const unsigned char *pDiskImage, const unsigned long DiskImageSize)
{
	BOOL			ValidImage = FALSE;

	if (pDiskImage != NULL)
	{
		picfileformatheader *pHeader = (picfileformatheader *)pDiskImage;

		if (memcmp(pHeader->HEADERSIGNATURE, "HXCPICFE", 8) == 0)
		{
			if (pHeader->formatrevision != 0)
				return FALSE;

			/* has main header */

			if ((pHeader->number_of_side == 1) || (pHeader->number_of_side == 2))
			{
				/* 1 or 2 sides */

				if ((pHeader->number_of_track > 1) && (pHeader->number_of_track < 85))
				{
				
					/* TODO furthur checks */
					ValidImage = TRUE;
				}
			}
		}
	}

	return ValidImage;
}


void            ExtDskInternal_Hfe2ExtDskInternal(DISKIMAGE_UNIT *pUnit, const unsigned char *pDiskImage, const unsigned long DiskImageSize)
{
	EXTDSK_INTERNAL *pExtDsk = NULL;

	if (pDiskImage != NULL)
	{

		pExtDsk = ExtDskInternal_New();

		pUnit->pDiskImage = (unsigned char *)pExtDsk;

		if (pExtDsk != NULL)
		{
			int i;
			int TrackIndex;

			picfileformatheader *pHeader = (picfileformatheader *)pDiskImage;
			unsigned short TrackListOffset = pHeader->track_list_offset;
#ifndef CPC_LSB_FIRST
			TrackListOffset = SwapEndianWord(TrackListOffset);
#endif
			pictrack *pTrack = (pictrack *)(pDiskImage + TrackListOffset);
			for (i = 0; i < pHeader->number_of_track; i++)
			{
				unsigned short TrackDataSize = pTrack->track_len;
				unsigned short TrackDataOffset = pTrack->offset;
				const unsigned char *pTrackData;

				TrackIndex = (i*pHeader->number_of_side);

				ExtDskInternal_AddTrack(pExtDsk, TrackIndex);
#ifndef CPC_LSB_FIRST
				TrackDataOffset = SwapEndianWord(TrackDataOffset);
				TrackDataSize = SwapEndianWord(TrackDataSize);
#endif
				pTrackData = (const unsigned char *)(pDiskImage + TrackDataOffset);
			}
		}
	}
}
